#include <bits/stdc++.h>

using namespace std;

#ifdef DEBUG
    #define D(X) X
#else
    #define D(X)
#endif // DEBUG

template <typename T1,typename T2> ostream &operator<<(ostream &os, const pair<T1,T2> &p) {
    os << "(" << p.first << ";" << p.second << ")";
    return os;
}

template <typename T> ostream &operator<<(ostream &os, const vector<T> &v) {
    os << "[";
    for (const auto& el : v) {
        os << el << " ";
    }
    os << "]\n";
    return os;
}

typedef long long ll;
typedef long double ld;


int N; // N trkaca
ll K; // K-to preticanje
vector<int> yzero;
vector<int> k;
vector<pair<ld,int> > y00;

void sviPreseciSaX(ld x, vector<pair<ld,int>>& yx)
{
    for(int i=0;i<N;i++) {
        yx[i].first = x * k[i] + yzero[i];
        yx[i].second = i;
    }
}

ll prebrojPreseke(vector<pair<ld,int>>& yi)
{
    ll sum=0;
    int brojani=0;

    //D(cout << yi;)
    sort(yi.begin(),yi.end());
    //D(cout << yi;)
    for(int i=0;i<N;i++) {
        if(i == yi[i].second) {
            continue;
        }
        brojani++;
        sum += std::abs(yi[i].second - i);
    }
    brojani = (brojani==0) ? 0 : brojani-1;
    sum -= brojani;
    return sum;
}

ld nadjiPreticanjeKBinarnomPretragom()
{
    ld mid=-1, low=0, high=1000000000.0L;
    vector<pair<ld,int>> yMid(N);
    int depth = 0;
    ll presekaLevo=0;

    while (low-high <= 0.00001L && depth <= 48 ) {
        mid = low + (high - low) / 2.0L;

        sviPreseciSaX(mid, yMid);
        presekaLevo = prebrojPreseke(yMid);
        // ne proveravamo da li smo nasli vrednost, jer ne znamo koja je

        if (presekaLevo < K)
            low = mid + 0.000001L;
        else
            high = mid - 0.000001L;
        depth++;
    }
    //D(cout << yMid;)
    //D(cout << "presekaLevo=" << presekaLevo << endl;)
    //D(cout << "depth=" << depth << endl;)
    //D(cout << "low=" << depth << endl;)
    //D(cout << "high=" << depth << endl;)
    //D(cout << "mid=" << mid << endl;)

    return mid;
}

int main()
{
    cin >> N >> K;
    int xi, vi;
    yzero.resize(N);
    k.resize(N);
    y00.resize(N);
    for(int i=0;i<N;i++) {
        cin >> xi >> vi;
        yzero[i] = xi;
        k[i] = vi;
        //y00[i] = make_pair(1000000000LL * vi + xi, i);
        D(y00[i] = make_pair(2.167L * vi + xi, i);)
    }
    //D(cout << "y00=" << y00;)
    D(ll result = prebrojPreseke(y00);)
    //D(cout << "result=" << result << endl;)

    cout << fixed << setprecision(15) << nadjiPreticanjeKBinarnomPretragom() << endl;

    return 0;
}